 ; Ŀ
 ;   Chalm - chgtext for every text entity and attribute in a drawing.     
 ;   Copyright 1995, 2008 by Rocket Software Ltd.                          
 ;   Science has yet to find any fossilized jellyfish.                     
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Tuskt - change text or mtext strings in a block definition.           
 ;   Notes: 1. Entnext returns nil after the last entity in a block        
 ;             definition.                                                 
 ;          2. An empty block has one subentity of type Endblk.            
 ;   Arguments: Namm, the first subentity ename.                           
 ;              Oldstr, the search string.                                 
 ;              Newstr, the new string.                                    
 ;   Returns a list of the number of strings changed and the total         
 ;   number of changes.                                                    
 ; 
 (DEFUN TUSKT (namm oldstr newstr / attchg chgnum entt typ prom1 prom2 altr
                                                                  mods nup)
  (setq attchg 0)
  (setq chgnum 0)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (setq typ (cdr (assoc 0 entt)))
         (if (and (member typ '("TEXT" "MTEXT"))
                  (setq prom1 (assoc 1 entt)))
             (progn
                  (setq prom2 (cdr prom1))
                  (setq altr (chug oldstr newstr prom2))
                  (if (> (setq mods (cadr altr)) 0)      ; if any changes made
                      (progn
                           (setq nup (car altr))
                           (entmod (subst (cons 1 nup) prom1 entt))
                           (setq attchg (1+ attchg))
                           (setq chgnum (+ chgnum mods))))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (list attchg chgnum))
 ; Ŀ
 ;   Tuskt end.                                                            
 ; 

 ; Ŀ
 ;   Chalm - the controller.                                               
 ; 
 (DEFUN C:CHALM (/ ccp cont chlin chnum dd notouch rad ss ss0 len num changs
                   strch enam txt entt altr mods newtxt pa chaags attch esub
                                                            defmod chg blist)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a list of blocks not to change, deduce the marker size.          
 ; 
  (setq notouch ())
  (setq rad (/ (getvar "viewsize") 45))
 ; Ŀ
 ;   Get existing and replacement strings.                                 
 ; 
  (if (= (type cc) 'STR)
      (progn
           (setq ccp (getstring t (strcat "\nExisting string <" cc ">:")))
           (if (/= ccp "") (setq cc ccp)))
      (progn
           (setq cont t)
           (while cont
                 (setq cc (getstring t "\nOld string:"))
                 (if (= cc "")
                 (princ "Can't search for nothing.")
                 (setq cont nil)))))
  (setq dd (getstring t "Replacement string:"))
  (setq chlin 0)
  (setq chnum 0)
 ; Ŀ
 ;   Get entities to change.                                               
 ; 
  (prompt "\nSelect text and blocks or <Return> for entire drawing: ")
  (setq glist '((-4 . "<or")
                 (0 . "text") (0 . "mtext") (0 . "insert")
                (-4 . "or>")))
  (if (null (setq ss0 (ssget glist)))
      (setq ss0 (ssget "x" glist)))
 ; Ŀ
 ;   Change the text and mtext as required.                                
 ; 
  (if ss0 (setq ss (ssget "p" '((-4 . "<or") (0 . "text")
                                             (0 . "mtext") (-4 . "or>")))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Txt")))
  (setq num 0)
  (setq changs 0)
  (setq strch 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq altr (chug cc dd txt))
         (if (> (setq mods (cadr altr)) 0)           ; if any changes made
                (progn
                     (setq newtxt (car altr))
                     (setq changs (+ changs mods))
                     (setq strch (1+ strch))
                     (setq pa (cdr (assoc 10 entt)))
                     (grdraw (polar pa (/ pi 4) rad)
                             (polar pa (* 1.25 pi) rad) 1)
                     (grdraw (polar pa (* pi 0.75) rad)
                             (polar pa (* pi 1.75) rad) 1)
                     (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))))
 ; Ŀ
 ;   Change the blocks.                                                    
 ; 
  (setq num 0)
  (setq chaags 0)
  (setq attch 0)
  (if ss0
      (progn
           (command "select" ss0 "")
           (setq ss (ssget "p" '((0 . "insert"))))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Att")))
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq esub (entnext enam))
 ; Ŀ
 ;   First change text and mtext in the block definition if it hasn't      
 ;   already been done.                                                    
 ; 
         (setq blnam (cdr (assoc 2 (entget enam))))
         (if (not (member blnam blist))
             (progn
                  (setq blist (cons blnam blist))
                  (setq blokdat (tblsearch "block" blnam))
                  (setq chgs (tuskt (cdr (assoc -2 blokdat)) cc dd))
                  (if (> (car chgs) 0)
                      (progn
                           (setq defmod t)
                           (write-line (strcat "Block definition "
                                                blnam " modified."))))))
 ; Ŀ
 ;   Change the blocks.                                                    
 ; 
         (setq chg ())
         (while (and (setq entt (entget enam))
                     (not (member (setq blnam (cdr (assoc 2 entt))) notouch))
                     (= 1 (cdr (assoc 61 entt)))
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub))))))
                (if (setq txt (cdr (assoc 1 entt)))
                    (progn
                         (setq altr (chug cc dd txt))
                         (if (> (setq mods (cadr altr)) 0) ; if changes made
                             (progn
                                  (setq chg T)
                                  (setq newtxt (car altr))
                                  (setq chaags (+ chaags mods))
                                  (setq attch (1+ attch))
                                  (setq pa (cdr (assoc 10 entt)))
                                  (grdraw (polar pa (/ pi 4) rad)
                                          (polar pa (* 1.25 pi) rad) 7)
                                  (grdraw (polar pa (* pi 0.75) rad)
                                          (polar pa (* pi 1.75) rad) 7)
                                  (entmod (subst (cons 1 newtxt)
                                                 (assoc 1 entt) entt))))))
                (setq esub (entnext esub)))
         (if chg (entupd enam))
         (if defmod (command ".regen")))
 ; Ŀ
 ;   Debrief the user.                                                     
 ; 
  (write-line (strcat (itoa changs) " change" (if (/= changs 1) "s" "") " in "
                      (itoa strch) " text string"  (if (/= strch 1) "s." ".")))
  (write-line (strcat (itoa chaags) " change" (if (/= chaags 1) "s" "") " in "
                      (itoa attch) " attribute" (if (/= attch 1) "s." ".")))
  (command "undo" "end")
 (princ))